/*****************************************************************************
*  LPC15xx WS2811 LED driver demo for MC100 rev A board
*
*  1. Use SCT1 timer to transmit WS2811 LED driver frames (24 bit)
*  2. SCT1_OUT0 is linked to P0_1
*****************************************************************************/
#include "LPC15xx.h"
#include "sct1_ws2811.h"

volatile int busy;
volatile int count;

const uint16_t pattern[] =
{
    0x123, 0x456,                                      // 24 bit WS2811 frames split into 2 x 12 bits
    0xFF0, 0x0CC,
    0x555, 0x555,
    0x800, 0x001,
};

void SCT1_IRQHandler(void)
{
    LPC_SCT1->EVFLAG = (1u << 10);                     // clear interrupt flag

    if(LPC_SCT1->STATE_L == 12)                        // for debug help
        LPC_GPIO->NOT[0] = (1 << 7);                   // toggle pin P0_7 (LED1)

    if (++count < sizeof(pattern)/sizeof(pattern[0]))  // count nr of frames
    {
        LEDDRIVER_write(pattern[count]);               // write next frame
    }
    else
    {
        LEDDRIVER_haltAfterFrame(1);                   // busy with last frame so halt after this one
    }

    if (LPC_SCT1->CTRL_L & 0x04)                       // if halted, transmission completed
    {
        busy = 0;
    }
}

int main(void) 
{
    LPC_SYSCON->SYSAHBCLKCTRL0 |= EN0_SWM    |         // enable SWM clock
                                  EN0_GPIO0;           // enable GPIO0 port clock

    LPC_SWM->PINASSIGN8        |= 0x000000FF;          // ASSIGN8 7:0) = FF
    LPC_SWM->PINASSIGN8        &= 0xFFFFFF01;          // SCT1_OUT0 = P0.1 = blue LED

    LPC_GPIO->DIR[0]           |= (1 << 7);            // configure P0.7 (LED1) as output

    LEDDRIVER_open();                                  // initialize SCT1 for WS2811 LED driver

    while (1)
    {
        if (!busy)
        {
            busy  = 1;                                 // transmission pending
            count = 0;                                 // used as frame counter
            LEDDRIVER_write(pattern[0]);               // preset first data word
            LEDDRIVER_haltAfterFrame(0);
            LEDDRIVER_start();                         // start transmission
        }
    }
}
